
<?php $__env->startSection('title', 'Chat - Admin'); ?>
<?php $__env->startSection('maincontent'); ?>
<?php
$data['heading'] = 'Chat';
$data['title'] = 'Chat Screen';
?>
<?php echo $__env->make('admin.layouts.topbar',$data, \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<div class="contentbar">
	<div class="row">
		<div class="col-md-12 m-b-30 dashboard-card">
			<div class="card">
				<div class="card-header">
					<a title="Back" href="<?php echo e(url()->previous()); ?>" class="ml-2 float-right btn btn-md btn-primary-rgba">
						<i class="feather icon-arrow-left" aria-hidden="true"></i> <?php echo e(__("Back")); ?>

					</a>
                    <div class="card-title">
                        <span class="text-dark"><?php echo e(__('Chat with :user',['user' => $reciever->name])); ?></b> </span>
                    </div>
				</div>

				<div class="card-body">
                    <div class="row">
                         <!-- Start col -->                       
                        <div class="col-lg-12 col-xl-12">       
                            <div class="chat-detail">
                                <div class="chat-head">
                                    <ul class="list-unstyled mb-0">
                                        <li class="media">

                                            <?php if($reciever->user_img != '' &&
                                            file_exists(public_path().'/images/user_img/'.$reciever->user_img)): ?>
                                            <img width="50px" src="<?php echo e(url('images/user_img/'.$reciever->user_img)); ?>" alt="profilephoto" class="img-fluid align-self-center mr-3 rounded-circle">
                                            <?php else: ?>
                                            <img width="50px" src="<?php echo e(Avatar::create($reciever->name)->toBase64()); ?>" alt="profilephoto" class="img-fluid align-self-center mr-3 rounded-circle">
                                            <?php endif; ?>
                                            <div class="media-body">
                                                <h5 class="font-18">
                                                    <?php echo e($reciever->fname); ?> <?php echo e($reciever->lname); ?>

                                                </h5>
                                                <p class="indicators_status"></p>
                                            </div>
                                        </li>
                                    </ul>
                                </div>
                                <div style="max-height: 300px;overflow-y : scroll;" id="chat-body" class="chat-body" onmouseover="get_live_chat()">
                                    <?php $__empty_1 = true; $__currentLoopData = $conversation->chat; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $chat): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>                                       
                                       
                                            <div class="chat-message <?php echo e($chat->user_id == auth()->id() ? "chat-message-right" : "chat-message-left"); ?>">
                                                <div class="chat-message-text">
                                                    <?php if($chat->type == 'media'): ?>
                                                        <a href="<?php echo e(url('images/conversations/'.$chat->media)); ?>" data-lightbox="image-1" data-title="<?php echo e($chat->media); ?>">    
                                                            <img src="<?php echo e(url('images/conversations/'.$chat->media)); ?>" alt="<?php echo e($chat->media); ?>" width="300px" class="img-fluid img-thumbnail">
                                                        </a>
                                                    <?php else: ?> 
                                                        <span>
                                                            <?php echo e($chat->message); ?>

                                                        </span>
                                                    <?php endif; ?>
                                                </div>
                                                <div class="chat-message-meta">
                                                    <small><?php echo e($chat->created_at->format('d-m-Y - h:i A')); ?>

                                                        <?php if($chat->user_id == auth()->id()): ?>
                                                        <i class="feather icon-check ml-2 <?php echo e($chat->status=='Seen'?"text-info":''); ?>"></i>
                                                        <?php endif; ?>
                                                    </small>
                                                </div>
                                            </div>       
                                             <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?> 
                                             <h4 class="no_conv text-center text-muted">
                                            <i class="feather icon-message-circle"></i> <?php echo e(__("Start a conversation with ")); ?> <?php echo e($reciever->name); ?>

                                        </h4>

                                    <?php endif; ?>
                                    <div class="chatscreen">
                                    </div>
                                </div>
                                <div class="chat-bottom">
                                    <div class="chat-messagebar">
                                        <form class="chatform" id="chatform" action="javascript:void(0)" enctype="multipart/form-data">

                                            <div class="input-group">
                                                <input required autofocus type="text" name="message" class="typemessage form-control" placeholder="Type a message..." aria-label="Text">
                                                <div class="input-group-append">
                                                    <input accept="image/*" type="file" name="media" class="file_choose form-control">
                                                    <button class="btn btn-round btn-secondary-rgba" type="button" id="button-addonlink"><i class="feather icon-image"></i></button>
                                                    <button class="sendMessage btn btn-round btn-primary-rgba" type="button" id="button-addonsend"><i class="feather icon-send"></i></button>
                                                </div>
                                            </div>

                                        </form>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <!-- End col -->
                    </div>
				</div>
			</div>
		</div>
	</div>
</div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('script'); ?>
<script src="https://js.pusher.com/7.0.3/pusher.min.js"></script>
<script>

    $.ajaxSetup({
        headers: {
            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        }
    });
    
    setTimeout(() => {
        scrolldown();
    }, 1000);

    function scrolldown(){
        $('body').css('overflow','auto');
        var objDiv = document.getElementById("chat-body");
        objDiv.scrollTop = objDiv.scrollHeight;
    }

    var rec = <?php echo e($conversation->sender_id == auth()->id() ? $conversation->receiver_id : $conversation->sender_id); ?>;
    var conv_id = "<?php echo e($conversation->id); ?>";
    var conver_id = "<?php echo e($conversation->conv_id); ?>";
    var id = <?php echo e(auth()->id()); ?>;

    $('.sendMessage').on('click',function(){

        if($('.file_choose').val() == '' && $('.typemessage').val() == ''){
            alert('Message or media is required !');
            return false;
        }

        "use Strict";
        message();
        
    });

    $('.chatform').on('submit',function(){

        "use Strict";

        message();

    });

    $('#button-addonlink').on('click',function(){
        $('.file_choose').click();
    });

    $('.file_choose').on('change', function(e) {
        if (!confirm("are you sure want to sent this file "+ e.target.files[0].name+'?')) {
            e.preventDefault();
            $('.file_choose').val('');
        }else{
            message();
            $('.file_choose').val('');
        }
    });

    function message(){
        
        $.ajaxSetup({
            headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            }
        });

        var formData =  new FormData($('#chatform')[0]);

        formData.append('rec_id',rec);

        $.ajax({
            method : 'POST',
            headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                },
            url  : '<?php echo e(route('send.message',$conversation->id)); ?>',
            dataType : 'json',
            data : formData,
            cache : false,
            contentType: false,
            processData: false,
            success : function(response){

                if(response.status == 'success'){
                    $('.typemessage').val('');
                    get_live_chat();
                }else{
                    alert('Failed to sent message: '+response.message);
                    return false;
                }
            }
        });

        
    }

    // Enable pusher logging - don't include this in production
    Pusher.logToConsole = true;
    function get_live_chat() {
        $.ajax({
            method : 'POST',
            headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                },
            url  : '<?php echo e((route('get.live.chat',$conversation->conv_id))); ?>',
            dataType : 'json',
            cache : false,
            contentType: false,
            processData: false,
            success : function(response){
                $('#chat-body').html(response.chat_model);
            }
        });
    }
    var channel = '';
    function debounce(func, wait, immediate) {
        var timeout;
        return function() {
            var context = this, args = arguments;
            var later = function() {
                timeout = null;
                if (!immediate) func.apply(context, args);
            };
            var callNow = immediate && !timeout;
            clearTimeout(timeout);
            timeout = setTimeout(later, wait);
            if (callNow) func.apply(context, args);
        };
    };
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('admin.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/elimun/public_html/Modules/Chatboard/Resources/views/chat/chat_screen.blade.php ENDPATH**/ ?>