
<?php $__env->startSection('title', __('Resume - Admin')); ?>
<!-- section start -->
<?php $__env->startSection('maincontent'); ?>
<?php
$data['heading'] = 'Resume';
$data['title'] = 'Resume';
?>
<?php echo $__env->make('admin.layouts.topbar',$data, \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<!-- component end -->
<!-- Start contentbar -->
<div class="contentbar">
    <!-- Start row -->
    <div class="row">
        <!-- Start col -->
        <div class="col-lg-12">
            <!-- Start card -->
            <div class="card dashboard-card m-b-30">
                <!-- Start card header -->
                <div class="card-header">
                    <h5 class="card-title"><?php echo e(__('Resume')); ?></h5>
                </div>
                <!-- end card header -->
                <!-- Start card body -->
                <div class="card-body">
                    <!-- Start table div -->
                    <div class="table-responsive">
                        <!-- Start table-->
                        <table id="datatable-buttons" class="table table-striped table-bordered">
                            <thead>
                                <tr>
                                    <th><?php echo e(__('Id')); ?></th>
                                    <th><?php echo e(__('Name')); ?></th>
                                    <th><?php echo e(__('Profession')); ?></th>
                                    <th><?php echo e(__('Email')); ?></th>
                                    <th><?php echo e(__('Phone no.')); ?></th>
                                    <th><?php echo e(__('Verified')); ?></th>
                                    <th><?php echo e(__('Approved')); ?></th>
                                    <th><?php echo e(__('Action')); ?></th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__currentLoopData = $personals; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $personal): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td>
                                        <?php echo e(filter_var($key+1)); ?>

                                    </td>
                                    <td>
                                        <?php echo e(filter_var($personal->fname)); ?>

                                    </td>
                                    <td>
                                        <?php echo e(filter_var($personal->profession)); ?>

                                    </td>
                                    <td>
                                        <?php echo e(filter_var($personal->email)); ?>

                                    </td>

                                    <td>
                                        <?php echo e(filter_var($personal->phone)); ?>

                                    </td>
                                    <!-- varified button -->
                                    <td>
                                        <label class="switch">
                                            <input class="verified" type="checkbox"
                                                data-id="<?php echo e(filter_var($personal->id)); ?>" name="verified"
                                                <?php echo e(filter_var($personal->verified) == '1' ? 'checked' : ''); ?>>
                                            <span class="knob"></span>
                                        </label>
                                    </td>
                                    <!-- status button -->
                                    <td>
                                        <label class="switch">
                                            <input class="status" type="checkbox"
                                                data-id="<?php echo e(filter_var($personal->id)); ?>" name="status"
                                                <?php echo e(filter_var($personal->status) == '1' ? 'checked' : ''); ?>>
                                            <span class="knob"></span>
                                        </label>
                                    </td>

                                    <td>
                                        <div class="dropdown">
                                            <button class="btn btn-round btn-outline-primary" type="button"
                                                id="CustomdropdownMenuButton1" data-toggle="dropdown"
                                                aria-haspopup="true" aria-expanded="false"><i
                                                    class="feather icon-more-vertical-"></i></button>
                                            <div class="dropdown-menu" aria-labelledby="CustomdropdownMenuButton1">
                                                <!-- view button -->
                                                <a class="dropdown-item"
                                                    href="<?php echo e(route('resume.view',["id" => filter_var($personal->user_id)])); ?>"><i
                                                        class="feather icon-eye mr-2"></i><?php echo e(__("View")); ?></a>
                                                <!-- delete button -->
                                                <a class="dropdown-item btn btn-link" data-toggle="modal"
                                                    data-target="#delete_<?php echo e(filter_var($personal->id)); ?>">
                                                    <i class="feather icon-delete mr-2"></i><?php echo e(__("Delete")); ?></a>
                                                </a>
                                            </div>
                                        </div>
                                        <!-- delete Modal start -->
                                        <div class="modal fade bd-example-modal-sm"
                                            id="delete_<?php echo e(filter_var($personal->id)); ?>" tabindex="-1" role="dialog"
                                            aria-hidden="true">
                                            <div class="modal-dialog modal-sm">
                                                <div class="modal-content">
                                                    <div class="modal-header">
                                                        <h5 class="modal-title" id="exampleSmallModalLabel">
                                                            <?php echo e(__("Delete")); ?></h5>
                                                        <button type="button" class="close" data-dismiss="modal"
                                                            aria-label="Close">
                                                            <span aria-hidden="true">&times;</span>
                                                        </button>
                                                    </div>
                                                    <div class="modal-body">
                                                        <h4><?php echo e(__('Are You Sure ?')); ?></h4>
                                                        <p><?php echo e(__('Do you really want to delete ? ')); ?>

                                                            <?php echo e(__('This process cannot be undone.')); ?></p>
                                                    </div>
                                                    <div class="modal-footer">
                                                        <form method="post"
                                                            action="<?php echo e(route('resume.destroy',['id' => filter_var($personal->user_id)])); ?>"
                                                            class="pull-right">
                                                            <?php echo e(csrf_field()); ?>

                                                            <?php echo e(method_field("DELETE")); ?>

                                                            <button type="reset" class="btn btn-secondary"
                                                                data-dismiss="modal"><?php echo e(__("No")); ?></button>
                                                            <button type="submit"
                                                                class="btn btn-primary"><?php echo e(__("Yes")); ?></button>
                                                        </form>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <!-- delete Model ended -->
                                    </td>
                                </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                        <!-- end table -->
                    </div>
                    <!-- end table div -->
                </div>
                <!-- end card body -->
            </div>
            <!-- end card -->
        </div>
        <!-- end col -->
    </div>
    <!-- end row -->
</div>
<!-- end contentbar -->
<?php $__env->stopSection(); ?>
<!--section end -->
<!-- This section will contain javacsript start -->
<?php $__env->startSection('script'); ?>
<script>
    var url = <?php echo json_encode(route('resume.resumestatus'), 15, 512) ?>;
    var verify = <?php echo json_encode(route('resume.resumeverified'), 15, 512) ?>;
</script>
<script src="<?php echo e(Module::asset('resume:js/status.js')); ?>"></script>
<?php $__env->stopSection(); ?>
<!-- This section will contain javacsript end -->
<?php echo $__env->make('admin.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/elimun/public_html/Modules/Resume/Resources/views/admin/index.blade.php ENDPATH**/ ?>